/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{  Copyright (c) 2003 Borland Software Corporation      }
{                                                       }
{*******************************************************/

using System;
using System.Data;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.ComponentModel.Design.Serialization;
using System.Drawing;
using System.Drawing.Design;
using System.Text;


namespace Borland.Data.Web
{

   public enum AcceptColumnType
   {
   	actTextBlobOnly,
      actTextBlobAndString
   }

	/// <summary>
	/// Data Aware Memo control, with datalink to text blob fields
	/// </summary>
   #region DBWebMemo
	[Designer("Borland.Data.Web.DBWebControlDesigner"),
   ToolboxBitmap(typeof(Borland.Data.Web.DBWebMemo),
   "Borland.Data.Web.DBWebMemo.bmp"),
	ToolboxData("<{0}:DBWebMemo runat=server></{0}:DBWebMemo>")]
   public class DBWebMemo : TextBox, IDBWebColumnLink, IPostBackDataHandler
   {
      private DBWebColumnLink FColumnLink;
      private IDBWebColumnLink IColumnLink;
      private AcceptColumnType FValidColumnType;

   	public DBWebMemo() : base()
      {
         TextMode = TextBoxMode.MultiLine;
         Height = Unit.Parse("200px");
         Width = Unit.Parse("400px");
         FValidColumnType = AcceptColumnType.actTextBlobOnly;
         FColumnLink = new DBWebColumnLink(this);
         IColumnLink = (FColumnLink as IDBWebColumnLink);
      }

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);
			if( Page != null )
				Page.RegisterRequiresPostBack(this);
      }

		protected override void OnPreRender(EventArgs args)
		{
			base.OnPreRender(args);
			string s = Page.Request.QueryString[DBWebConst.sBorlandImageID];
         if( s != null )
         	return;
         DataBind();
         if( !ReadOnly )
         	Page.RegisterHiddenField(DBWebDataSource.IdentPrefix + this.ID, IColumnLink.TableName + DBWebConst.Splitter + IColumnLink.ColumnName);
		}

      #region IPostBackDataHandler
      // RaisePostDataChangedEvent is called prior to DataBind()
      // DataSet and related properties are NOT available here
      // Child controls are not available
		bool IPostBackDataHandler.LoadPostData(string postDataKey,
			NameValueCollection postCollection)
      {
         if( this.Visible )
	      	FColumnLink.LoadPostData(postDataKey, postCollection);
         return false;
      }

	   void IPostBackDataHandler.RaisePostDataChangedEvent()
   	{
	   }
      #endregion

      #region IDBWebDataLink
      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute("DBWebControl"),
		DefaultValue(null)]
      public string TableName
      {
      	get
         {
	      	return IColumnLink.TableName;
         }
      	set
         {
	      	IColumnLink.TableName = value;
         }
      }
		[LocalizableCategoryAttribute("DBWebControl"),
		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
		DefaultValue(null)]
      public IDBDataSource DBDataSource
      {
      	get
         {
         	return IColumnLink.DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }


      [Editor(typeof(Borland.Data.Web.MemoColumnPropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute("DBWebControl"),
		DefaultValue(null)]
      public string ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }
      #endregion

      [LocalizableCategoryAttribute("DBWebControl"),
      DefaultValue(AcceptColumnType.actTextBlobOnly)]
      public AcceptColumnType ValidColumnType
      {
      	get
         {
         	return FValidColumnType;
         }
      	set
         {
         	FValidColumnType = value;
         }
      }

 		protected override void Render(HtmlTextWriter output)
		{
      	bool error = ClassUtils.OutputErrors(Page, output, IColumnLink);
         if( !error || (IColumnLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logOnErrorPage )
         	base.Render(output);
         else  // if going to a separate error hmtl page, output "OK" button.
         {
         	ClassUtils.OutputOKButton(output);
            Page.Response.End();
         }
		}

		public override void DataBind()
      {
      	try
         {
	         if( ClassUtils.IsDesignTime(Page) && !FColumnLink.IsDataBound )
   	      	Text = this.ID;
      	   base.DataBind();
         	if( FColumnLink.IsDataBound )
	         {
   	      	Text = Convert.ToString(IColumnLink.DBDataSource.GetColumnValue(Page,
      	      					IColumnLink.TableName, IColumnLink.ColumnName));
         	   base.DataBind();
	         }
         }
         catch(Exception ex)
         {
         	if( !ClassUtils.IsDesignTime(Page) )
            {
	            Page.Response.Write(ClassUtils.GetInternalError(Page, IColumnLink, ex, this.ID));
            }
            else
            	throw new Exception(ex.Message);
         }
      }
   }
   #endregion

}


